<?php
session_start();
$user = 'matin';
$pass = 'M@tin2025';

if (!isset($_SERVER['PHP_AUTH_USER']) || !isset($_SERVER['PHP_AUTH_PW']) ||
    $_SERVER['PHP_AUTH_USER'] !== $user || $_SERVER['PHP_AUTH_PW'] !== $pass) {
    header('WWW-Authenticate: Basic realm="Restricted Area"');
    header('HTTP/1.0 401 Unauthorized');
    echo json_encode(['success' => false, 'message' => 'دسترسی محدود شده است.']);
    exit;
}

header('Content-Type: application/json');

// ---------- مسیرهای پایه ----------
$publicRoot = realpath(__DIR__ . '/..'); // مسیر public_html
$baseDirs = [
    '3DSKY'   => realpath($publicRoot . '/3DSKY'),
    'Texture' => realpath($publicRoot . '/Texture')
];

$baseURLs = [
    '3DSKY'   => 'https://dl.bimlearn.org/3DSKY',
    'Texture' => 'https://dl.bimlearn.org/Texture'
];

// ---------- بررسی فایل ----------
$path = realpath($_POST['path'] ?? '');
if (!$path || pathinfo($path, PATHINFO_EXTENSION) !== 'zip') {
    echo json_encode(['success' => false, 'message' => 'فایل معتبر نیست یا zip نیست.']);
    exit;
}

$allowed = false;
$baseDir = null;
$baseURL = null;
foreach ($baseDirs as $key => $dir) {
    if ($dir && strpos($path, $dir) === 0) {
        $allowed = true;
        $baseDir = $dir;
        $baseURL = $baseURLs[$key];
        break;
    }
}
if (!$allowed) {
    echo json_encode(['success' => false, 'message' => 'مسیر خارج از محدوده مجاز است.']);
    exit;
}

// ---------- اکسترکت فایل ----------
$zip = new ZipArchive;
if ($zip->open($path) === TRUE) {
    $extractTo = dirname($path) . '/' . pathinfo($path, PATHINFO_FILENAME);
    if (!file_exists($extractTo)) mkdir($extractTo, 0755, true);

    if ($zip->extractTo($extractTo)) {
        $zip->close();

        // مسیر نسبی برای لینک.php
        $relative = str_replace($baseDir, '', $extractTo);
        $redirect = 'link.php?path=' . urlencode($baseDir . $relative);

        echo json_encode(['success' => true, 'redirect' => $redirect]);
    } else {
        echo json_encode(['success' => false, 'message' => 'استخراج فایل ناموفق بود.']);
    }
} else {
    echo json_encode(['success' => false, 'message' => 'باز کردن فایل zip ناموفق بود.']);
}
