<?php
session_start();
$user = 'matin'; $pass = 'M@tin2025';
if (!isset($_SERVER['PHP_AUTH_USER'], $_SERVER['PHP_AUTH_PW']) ||
    $_SERVER['PHP_AUTH_USER'] !== $user || $_SERVER['PHP_AUTH_PW'] !== $pass) {
    header('WWW-Authenticate: Basic realm="Restricted"');
    header('HTTP/1.0 401 Unauthorized');
    exit("دسترسی محدود.");
}

$publicRoot = realpath(__DIR__ . '/..');
$baseDirs = [
    '3DSKY'   => realpath($publicRoot . '/3DSKY'),
    'Texture' => realpath($publicRoot . '/Texture')
];
$baseURLs = [
    '3DSKY'   => 'https://dl.bimlearn.org/3DSKY',
    'Texture' => 'https://dl.bimlearn.org/Texture'
];

$currentPath = isset($_GET['path']) ? realpath($_GET['path']) : $baseDirs['3DSKY'];
$currentBase = null; $currentURLBase = null;
foreach ($baseDirs as $key=>$dir) {
    if ($dir && strpos($currentPath, $dir) === 0) {
        $currentBase = $dir; $currentURLBase = $baseURLs[$key];
        break;
    }
}
if (!$currentBase) die("دسترسی غیرمجاز.");

$currentURL = $currentURLBase . str_replace($currentBase, '', $currentPath);
?>
<!DOCTYPE html>
<html lang="fa">
<head>
<meta charset="UTF-8">
<title>فایل‌منیجر</title>
<script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100 p-6 font-sans">
<!-- مسیرهای اصلی -->
<div class="mb-4 flex space-x-4 rtl:space-x-reverse">
  <a href="link.php?path=<?=urlencode($baseDirs['3DSKY'])?>" 
     class="px-3 py-2 rounded <?=($currentBase==$baseDirs['3DSKY']?'bg-blue-600 text-white':'bg-gray-200 text-black')?>">📁 3DSKY</a>

  <a href="link.php?path=<?=urlencode($baseDirs['Texture'])?>" 
     class="px-3 py-2 rounded <?=($currentBase==$baseDirs['Texture']?'bg-blue-600 text-white':'bg-gray-200 text-black')?>">📁 Texture</a>
</div>

<a href="link.php" class="text-red-600 font-bold">← بازگشت</a>

<!-- آپلود معمولی -->
<form action="upload.php" method="post" enctype="multipart/form-data" class="bg-white p-4 rounded shadow mb-6 max-w-md">
  <label class="block font-bold mb-2">آپلود معمولی (ZIP/RAR):</label>
  <input type="hidden" name="currentPath" value="<?=htmlspecialchars($currentPath)?>">
  <input type="file" name="upload" class="mb-2" required>
  <button type="submit" class="bg-green-600 hover:bg-green-700 text-white px-4 py-2 rounded">آپلود</button>
</form>

<!-- آپلود با Pause/Resume -->
<div class="bg-white p-4 rounded shadow mb-6 max-w-md">
  <label class="block font-bold mb-2">آپلود قابل توقف/ادامه (ZIP/RAR):</label>
  <input type="file" id="fileInput" class="mb-2">
  <div class="space-x-2 rtl:space-x-reverse">
    <button id="startBtn" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded">شروع آپلود</button>
    <button id="pauseBtn" class="bg-yellow-600 hover:bg-yellow-700 text-white px-4 py-2 rounded">توقف</button>
  </div>
  <div class="w-full bg-gray-300 h-6 rounded mt-3 hidden" id="progressBox">
    <div id="progressBar" class="bg-green-500 h-6 rounded text-xs text-white text-center">0%</div>
  </div>
</div>

<!-- آپلود از لینک -->
<form action="upload_from_url.php" method="POST" class="mb-6 bg-white p-4 rounded shadow max-w-md">
  <label class="block font-bold mb-2">آپلود با لینک (zip/rar):</label>
  <input type="url" name="fileurl" class="w-full border p-2 mb-2" placeholder="https://example.com/file.zip" required/>
  <input type="hidden" name="currentPath" value="<?=htmlspecialchars($currentPath)?>">
  <button class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded">بارگذاری</button>
</form>

<!-- جستجو -->
<input type="text" id="search" onkeyup="searchFiles()" placeholder="🔍 جستجو..." class="p-2 border rounded mb-4 w-full max-w-md"/>
<div id="searchResults"></div>

<form id="bulkDeleteForm" method="POST" action="bulk_delete.php">
<ul class="space-y-2 bg-white p-4 rounded shadow">
<?php
$items = scandir($currentPath); natsort($items);
$i=1;
foreach($items as $item) if($item!='.'&&$item!='..'){
  $full = "$currentPath/$item"; $ext=strtolower(pathinfo($item,PATHINFO_EXTENSION));
  $size=is_file($full)?number_format(filesize($full)/(1024*1024),2).' MB':'—';
  $id="file_".md5($full);
  echo '<li class="flex items-center justify-between">';
  if(is_file($full)){
    echo "<label class='flex items-center space-x-2 rtl:space-x-reverse'><input type='checkbox' name='files[]' value='".htmlspecialchars($full)."' class='mr-2'/>".
         "📄 <span id='$id'>$i- $item</span> <span class='text-gray-500 text-xs'>($size)</span></label>";
    echo "<div class='space-x-2 rtl:space-x-reverse'>";
    echo "<a href='".$currentURL."/".rawurlencode($item)."' target='_blank' class='bg-blue-500 hover:bg-blue-700 text-white px-4 py-2 rounded transition'>دانلود</a>";
    if($ext==='zip'){
      echo "<button type='button' onclick='extractZip(\"".addslashes($full)."\")' class='bg-yellow-500 text-white px-4 py-2 rounded'>📦 استخراج</button>";
    }
    echo "<button type='button' onclick='renameFile(\"".addslashes($full)."\",\"$id\")' class='bg-pink-500 text-white px-4 py-2 rounded'>✏️ تغییر نام</button>";
    if(in_array($ext, ['jpg','jpeg','png','gif','webp','bmp','tif','tiff'])){
      echo "<button type='button' onclick='previewImage(\"".$currentURL."/".rawurlencode($item)."\")' class='bg-gray-500 text-white px-4 py-2 rounded'>👁 پیش‌نمایش</button>";
    }
    echo "</div>";
  }else{
    echo "<div class='flex items-center space-x-2 rtl:space-x-reverse'>📁<a href='?path=".urlencode($full)."' class='text-green-700 font-semibold'>".htmlspecialchars($item)."</a></div>";
  }
  echo "</li>"; if(is_file($full)) $i++;
}
?>
</ul>
<button type="submit" class="mt-4 bg-red-600 hover:bg-red-700 text-white px-4 py-2 rounded">🗑 حذف فایل‌های انتخاب‌شده</button>
</form>

<!-- دکمه بازگشت به بالا -->
<button onclick="scrollToTop()" class="fixed bottom-4 right-4 bg-gray-700 hover:bg-gray-900 text-white p-3 rounded-full">↑</button>

<script>
const currentPath="<?=addslashes($currentPath)?>";

// آپلود Resume
let paused=false, currentChunk=0;
document.getElementById("pauseBtn").addEventListener("click",()=>{
  paused=!paused;
  document.getElementById("pauseBtn").innerText=paused?"ادامه":"توقف";
  if(!paused) uploadNextChunk();
});
document.getElementById("startBtn").addEventListener("click",()=>{
  currentChunk=0; paused=false; uploadNextChunk();
});
function uploadNextChunk(){
  const file=document.getElementById("fileInput").files[0];
  if(!file) return alert("لطفا فایل انتخاب کنید.");
  const chunkSize=1024*1024; // 1MB
  const totalChunks=Math.ceil(file.size/chunkSize);
  if(currentChunk>=totalChunks) return;
  if(paused) return;
  const start=currentChunk*chunkSize;
  const end=Math.min(file.size,start+chunkSize);
  const blob=file.slice(start,end);
  const fd=new FormData();
  fd.append("upload",blob);
  fd.append("chunkIndex",currentChunk);
  fd.append("totalChunks",totalChunks);
  fd.append("filename",file.name);
  fd.append("currentPath",currentPath);
  fetch("upload.php",{method:"POST",body:fd})
    .then(r=>r.text())
    .then(res=>{
      console.log(res);
      currentChunk++;
      const percent=Math.floor((currentChunk/totalChunks)*100);
      const bar=document.getElementById("progressBar");
      document.getElementById("progressBox").classList.remove("hidden");
      bar.style.width=percent+"%"; bar.innerText=percent+"%";
      if(currentChunk<totalChunks){ uploadNextChunk(); }
      else { alert("آپلود کامل شد!"); location.reload(); }
    });
}

// بقیه فانکشن‌ها
document.getElementById('bulkDeleteForm').addEventListener('submit',function(e){
  const cbs=document.querySelectorAll("input[name='files[]']:checked");
  if(cbs.length===0){alert("هیچ فایلی انتخاب نشده.");e.preventDefault();return;}
  const names=[...cbs].map(cb=>cb.closest('li').querySelector('span').innerText);
  if(!confirm("آیا مطمئن هستید که می‌خواهید این فایل‌ها را حذف کنید؟\n\n"+names.join("\n"))){e.preventDefault();}
});
function scrollToTop(){window.scrollTo({top:0,behavior:'smooth'});}
function extractZip(path){
  fetch('extract.php',{method:'POST',headers:{'Content-Type':'application/x-www-form-urlencoded'},body:'path='+encodeURIComponent(path)})
  .then(r=>r.json()).then(d=>{d.success?location.href='link.php?path='+encodeURIComponent(d.redirect):alert(d.message)});
}
function renameFile(oldPath,spanId){
  const span=document.getElementById(spanId),cur=span.innerText.trim();
  const n=prompt("نام جدید فایل:",cur);if(!n)return; if(!confirm("آیا مطمئن هستید؟"))return;
  fetch('rename.php',{method:'POST',headers:{'Content-Type':'application/x-www-form-urlencoded'},body:`oldPath=${encodeURIComponent(oldPath)}&newName=${encodeURIComponent(n)}`})
  .then(r=>r.text()).then(m=>{alert(m);span.textContent=n;span.style.color="#ff8c00";});
}
function searchFiles(){
  const q=document.getElementById('search').value,div=document.getElementById('searchResults');
  if(!q.trim()){div.innerHTML='';return;}
  fetch('search.php?q='+encodeURIComponent(q)+'&path='+encodeURIComponent(currentPath))
  .then(r=>r.text()).then(ht=>div.innerHTML=ht);
}
function previewImage(url){
  const w=window.open("","Preview","width=600,height=600");
  w.document.write("<img src='"+url+"' style='max-width:100%'>");
}
</script>
</body></html>
